


flag_ow		equ	flag+1		;one wire variables
cmpt		equ	flag_ow+1	; : 2 octets ?		(compteur interne)
bit_AB		equ	cmpt+2
bit_index	equ	bit_AB+1
OWBUFFER	equ	bit_index+1	;(variable servant au transfert sur le bus ONE WIRE)
OWBUFFER1	equ	OWBUFFER+1
OWBUFFER2	equ	OWBUFFER1+1
OWBUFFER3	equ	OWBUFFER2+1
OWBUFFER4	equ	OWBUFFER3+1
OWBUFFER5	equ	OWBUFFER4+1
OWBUFFER6	equ	OWBUFFER5+1
OWBUFFER7	equ	OWBUFFER6+1
OWBUFFER8	equ	OWBUFFER7+1
OWBUFFER9	equ	OWBUFFER8+1
OWBUFFER1a	equ	OWBUFFER9+1
OWBUFFER2a	equ	OWBUFFER1a+1
OWBUFFER3a	equ	OWBUFFER2a+1
OWBUFFER4a	equ	OWBUFFER3a+1
OWBUFFER5a	equ	OWBUFFER4a+1
OWBUFFER6a	equ	OWBUFFER5a+1
OWBUFFER7a	equ	OWBUFFER6a+1
OWBUFFER8a	equ	OWBUFFER7a+1
OWBUFFER9a	equ	OWBUFFER8a+1
c_dif		equ	OWBUFFER9a+1
c1_dif		equ	c_dif+1
flagx		equ	c1_dif+1
nb_ibuttons	equ	flagx+1
crc		equ	nb_ibuttons+1
					;fin one wire variables



; Definition du port et du bit sur lequel est install
; le ou les composants one wire
#define		OW_BUS		PORTB,5



; ****************************************************************************
; ****************************************************************************
; *									MACROS								 	 *
; ****************************************************************************
; ****************************************************************************

; La macro suivante rgle le BUS en sortie et y impose un niveau bas
; Attention : les macros de slections de banques doivent tres prsents
OW_BUS_OUT Macro
		bsf	STATUS,RP0		; Banque 1
		bcf	OW_BUS			; = sortie
		bcf	STATUS,RP0		; Banque 0
		bcf	OW_BUS			; = niveau bas
		endM

; La macro suivante rgle le BUS en entre (on "relche" le bus)
OW_BUS_IN Macro
		bsf	STATUS,RP0		; Banque 1
		bsf	OW_BUS			; = entre
		bcf	STATUS,RP0		; Banque 0
		endM
; ****************************************************************************



;***********************************************************************************
; ****************************************************************************
; *							Dbut des routines	one wire dallas							 *
; ****************************************************************************
;**************************************************************************************
; ****************************************************************************

; ****************************************************************************
; commande selection "match rom"
;*********************************************************************************
match_r		call	pr_2_dig	;commande 
		movwf	OWBUFFER1
		call	pr_2_dig	;commande 
		movwf	OWBUFFER2
		call	pr_2_dig	;commande 
		movwf	OWBUFFER3
		call	pr_2_dig	;commande 
		movwf	OWBUFFER4
		call	pr_2_dig	;commande 
		movwf	OWBUFFER5
		call	pr_2_dig	;commande 
		movwf	OWBUFFER6
		call	pr_2_dig	;commande 
		movwf	OWBUFFER7
		call	pr_2_dig	;commande 
		movwf	OWBUFFER8
match_rom
	; Step 1 : Reset pulse
		call	ResetBUS	;attend fin reset

	; Step 2 : match ROM Command
		movlw	H'55'		; match ROM = 55h
		movwf	OWBUFFER
		call	OW_WRITE8	; On evoie le buffer sur le bus

		movlw	8
		movwf	tmp1
		movlw	OWBUFFER1
		movwf	FSR
next3		movfw	INDF
		movwf	OWBUFFER
		call	OW_WRITE8
		incf	FSR,f
		decfsz	tmp1,f
		goto	next3
		return

; ****************************************************************************
; ****************************************************************************
	; Step 3 :;ordre de conversion et lecture du scratchpad
convert_T	movlw	H'44'		; Convert T = 44h
		movwf	OWBUFFER
		call	OW_WRITE8
	
	;On teste que la conversion soit termine
	;valable uniquement en alimentation exterieure
	;pas en mode parasite
	
Tstready	call	OW_READS	; On lance un read slot
		xorlw	D'1'		; on compare avec '1'
		btfss	STATUS, Z	; flag Z positionn si =
		goto	Tstready	; si non =, on reteste
; ****************************************************************************
; Routine de reset avec test
ResetBUS
		call	OW_RESET	; On fait un Reset
		xorlw	'Y'		; on vrifie qu'il se soit bien pass
		btfss	STATUS, Z
		goto	ResetBUS	; si on a pas eu 'y' on recommence		
		return

; ****************************************************************************
	
; ****************************************************************************
Read_scratchpad
		movlw	H'BE'		
		movwf	OWBUFFER
		call	OW_WRITE8

r_8bytes			; Lecture des x octets
		movlw	8
		movwf	tmp1
		movlw	OWBUFFER1
		movwf	FSR
next2		call	OW_READ8	; lecture du premier octet LSB
		movf	OWBUFFER, W
		movwf	INDF
		incf	FSR,f
		decfsz	tmp1,f
		goto	next2
		goto	ResetBUS
		
; ****************************************************************************
; ****************************************************************************

write_scratchpad
		movlw	H'4E'		; write scratchpad = 4Eh
		movwf	OWBUFFER
		call	OW_WRITE8
		movfw	OWBUFFER1	; premier octet
		movwf	OWBUFFER
		call	OW_WRITE8
		movfw	OWBUFFER2	; second octet
		movwf	OWBUFFER
		call	OW_WRITE8
		movfw	OWBUFFER3	; troisime octet : configuration 9 bits
		movwf	OWBUFFER
		call	OW_WRITE8
		goto	ResetBUS
		
; ****************************************************************************
; ****************************************************************************
; Routine de reset du bus ONE WIRE

; ****************************************************************************
; Routine de reset avec test
; ****************************************************************************

OW_RESET
; Premire tape : on force le bus  0 pendant au moins 480 s

		OW_BUS_OUT		; On rgle en sortie le bus ONE WIRE
		call	t480		; Temporisation de 480 S
		OW_BUS_IN		; On relache le bus ONE WIRE	
	
; Deuxime partie : on attend une rponse sur le bus
; On va tester pendant 60 S le bus
; on a 5 s par itrations, donc 60/5=12 (on teste 12 fois le BUS)

		movlw	D'12'		; initialisation du compteur
		movwf	cmpt
sub_reset	btfss	OW_BUS		; teste le bus :
		goto	Etape3		; si il n'est plus  1, c'est bon
		decfsz	cmpt,f		; si il est  1, on compte,
		goto	sub_reset	; puis on boucle
		retlw	'N'		; Si on a fini de compter sans succs, on renvoie
					; le caractre 'N' dans le registre W

; Troisime tape : on a eu un front descendant sur le bus, on doit valider
; alors un "presence pulse" en vrifiant qu'il dure au moins 60s
; on a 5 s par itrations, donc 60/5=12

Etape3		movlw	D'12'		; initialisation du compteur
		movwf	cmpt
sub_etape3	btfsc	OW_BUS		; teste le bus :
		retlw	'N'		; si il n'est plus  0, il y a un problme
		decfsz	cmpt,f		; si il est  0, on continue de compter
		goto	sub_etape3	; on boucle
					; Si on arrive  la fin du compteur : on a le temps
					; minimum, donc une "presence pulse" valide
		call	t480		; Temporisation de 480 S
		retlw	'Y'		; On termine en renvoyant 'Y'


; ****************************************************************************
; ****************************************************************************
; routine READ POWER doit rester colle a OW_READS
read_power	movlw	H'B4'		;retour w=0 parasite
		movwf	OWBUFFER	;=1 alim externe
		call	OW_WRITE8	;puis OW_READS et retour
		
; ****************************************************************************
	; Routine READ SLOT
	; initialisation du compteur pour la temporisation rglable
	
OW_READS	movlw	D'20'
		movwf	cmpt
		
	; Etape 1 :
	; La squence suivant impose un niveau bas sur le bus pendant au moins 1s
	; valeur de scurit = 6s (moiti du temps max)
	
		OW_BUS_OUT	; impose un niveau bas
		NOP
		NOP
		NOP
		NOP
		
	; Attention : deux cycles pris par la macro OW_BUS_IN avant
	; et aprs le changement d'impdance
	
		OW_BUS_IN	; Relache le bus
	; Etape 2 :
	; On va lire maintenant sur le bus  la 15e s
	
		NOP	
		NOP
		NOP
		
	; l'exemple suivant teste deux fois le bus (pour tre sr)
	
		movlw	D'0'
		btfsc	OW_BUS	; teste le bus
		movlw	D'1'	;ok niveau haut
		btfsc	OW_BUS	; teste le bus
		movlw	D'1'	;ok niveau haut
	
	; Etape 3 : on attend jusqu' la fin du slot et on laisse un recovery time
	; On utilise la tempo rglable car on ne doit pas changer le contenu de W
	
		goto	tempoo	; Fin de la routine


; ****************************************************************************
; ****************************************************************************
; Routine WRITE 1 SLOT

	; Etape 1
	; La squence suivante impose un niveau bas sur le bus pendant au moins 1s
	; valeur de scurit = 6s (moiti du temps max)
	
OW_WRITE1S	OW_BUS_OUT	; sortie, niveau bas
		NOP
		NOP
		NOP
		NOP
		
	; Attention : deux cycles pris par la macro OW_BUS_IN avant
	; et aprs le changement d'impdance
	
		OW_BUS_IN	; Relache le bus
	
	; Etape 2 : on attend jusqu' la fin du slot et on laisse un recovery time
	
		goto	t60			; tempo de 60 s
	
; ****************************************************************************
; ****************************************************************************
; Routine Write 0 Slot ( attention : 0 = zro, pas la lettre 'O' )
	
	; Etape 1 : on impose un niveau bas sur le bus pendant toute la dure du slot

OW_WRITE0S	OW_BUS_OUT
		call	t60
		OW_BUS_IN
	
	; Etape 2 : recovery time
	
		NOP
		NOP
		NOP
		NOP
		NOP
		return

; ****************************************************************************
; ****************************************************************************
; Routine Read 8 ( = lecture de 8 bits conscutifs )
; Rsultat dans OWBUFFER
;1er bit LSB

OW_READ8	movlw	D'8'		; initialisation du compteur
		movwf	cmpt+1
sub_READ8	call	OW_READS	; lecture (READ SLOT), renvoie 1 ou 0 dans W
		xorlw	D'1'		; on teste la valeur dans W : le flag Z est positionn
		bcf	STATUS, C	; on prpositionne le flag C  0
		btfsc	STATUS, Z	; on teste le flag Z :
		bsf	STATUS, C	; si il est  1, on positionne le flag C
		rrf	OWBUFFER, F	; et on fait un dcallage dans le buffer avec le flag C
		decfsz	cmpt+1,f
		goto	sub_READ8 	; et on boucle
		return

; ****************************************************************************
; ****************************************************************************
; Routine Write 8 ( = criture de 8 bits conscutifs )
; octet  crire dans OWBUFFER

OW_WRITE8	movlw	D'8'		; initialisation du compteur
		movwf	cmpt+1

	; la squence suivante teste un  un tous les bits de l'octet  envoyer
	; et choisit  chaque fois quel Write Slot utiliser
	;on commence par le LSB
	
sub_write8	btfsc	OWBUFFER, 0	; choix du Write slot
		call	OW_WRITE1S	
		btfss	OWBUFFER, 0	; choix du Write slot
		call	OW_WRITE0S
		rrf	OWBUFFER,f	; rotation pour tester le bit suivant
		decfsz	cmpt+1,f
		goto	sub_write8	; bouclage
		return

; ****************************************************************************
; ****************************************************************************
; Temporisations

; Temporisation de 480 s
; 3s par itrations, donc 160*3 = 480 s
; +2s pour l'initialisation (ngligeable)
t480		movlw	D'160'
		movwf	cmpt
sub_t480	decfsz	cmpt,f
		goto	sub_t480
		return

; Temporisation de 60 s
; 3s par itrations, donc 20*3 = 60 s
; +2s pour l'initialisation (ngligeable)

t60		movlw	D'20'
		movwf	cmpt
sub_t60		decfsz	cmpt,f
		goto	sub_t60
		return

; Temporisation rglabe : charger dans cmpt la valeur de la temporisation
; tempo = 3s*cmpt+2s

tempoo		decfsz	cmpt,f
		goto	tempoo
		return

;***********************************************************************************
;***************************************************************************************
	; scratchpad byte 2,3,4 => eprom
	
copy		movlw	H'48'
		movwf	OWBUFFER
		call	OW_WRITE8	; On evoie le buffer sur le bus
		goto	Tstready	;on sort de la routine

;***********************************************************************************
;***************************************************************************************
	;eprom => scrtchpad

recall		movlw	H'B8'
		movwf	OWBUFFER
		call	OW_WRITE8	; On envoie le buffer sur le bus
		goto	Tstready

;***************************************************************************************
;	routine de recherche sur le bus des ibuttons au retour un ibutton trouv ou erreur *
;***************************************************************************************
cancel		decf	c1_dif,f	;dans le cas d'un dja fait
		btfsc	STATUS,Z	;si a 1 une dif de moins
		goto	fn_search
		movfw	c1_dif		;derniere dif en cours
		movwf	c_dif		;pour memoire
rom_search
		bcf	flagx,multidrop
		movfw	OWBUFFER1a
		movwf	OWBUFFER1		
		movfw	OWBUFFER2a
		movwf	OWBUFFER2		
		movfw	OWBUFFER3a
		movwf	OWBUFFER3		
		movfw	OWBUFFER4a
		movwf	OWBUFFER4		
		movfw	OWBUFFER5a
		movwf	OWBUFFER5		
		movfw	OWBUFFER6a
		movwf	OWBUFFER6		
		movfw	OWBUFFER7a
		movwf	OWBUFFER7		
		movfw	OWBUFFER8a
		movwf	OWBUFFER8		
		clrw
		movwf	bit_index
		movwf	c1_dif		;difference en cours
		bcf	flagx,vrai
	
	; Step 1 : Reset pulse
		call	ResetBUS
		xorlw	'Y'		; on compare avec 'Y'
		btfsc	STATUS,Z
		goto	err_ibuton

	; Step 2 : ROM Command
		incf	bit_index,f
		movlw	H'F0'		; ROM search = F0h
		movwf	OWBUFFER
		call	OW_WRITE8	; On evoie le buffer sur le bus
s1		clrw
		movwf	bit_AB
		call	OW_READS	; On lance un read slot pour bit A
		xorlw	D'1'		; on compare avec '1'
		btfss	STATUS, Z	; flag Z positionn si =
		bsf	bit_AB,0	; bit A =1
		call	OW_READS	; On lance un read slot pour bit B
		xorlw	D'1'		; on compare avec '1'
		btfss	STATUS, Z	; flag Z positionn si =
		bsf	bit_AB,1	; bit B =1
		movlw	D'0'		; bits A et B = 1 ?	
		xorwf	bit_AB,W	; bits A et B = 1 ?
		btfsc	STATUS, Z	; flag Z positionn si =
		goto	fin_searc

		movlw	D'3'		; bits A et B = 0 ?
		xorwf	bit_AB,W	; bits A et B = 0 ?
		btfsc	STATUS, Z	; flag Z positionn si =
		goto	conflit		;

		btfsc	bit_AB,0	;test etat du bit A ????
		goto	wb0

wb1		call	OW_WRITE1S	;on ecrit un 1
		bsf	STATUS,C	;preset carry
		goto	s2

wb11		btfsc	OWBUFFER1,0	;dif en cours tat du bit prcdemment
		goto	cancel
		bsf	flagx,v_bitd	;etat du bit derniere dif
		goto	wb1
	
wb00		bcf	flagx,fini	
		bcf	flagx,v_bitd	;etat du bit derniere dif

wb0		call	OW_WRITE0S
		bcf	STATUS,C	;preclear carry
s2		rrf	OWBUFFER8,f
		rrf	OWBUFFER7,f
		rrf	OWBUFFER6,f	
		rrf	OWBUFFER5,f
		rrf	OWBUFFER4,f
		rrf	OWBUFFER3,f
		rrf	OWBUFFER2,f
		rrf	OWBUFFER1,f
		incf	bit_index,f
		movlw	.65
		xorwf	bit_index,w		; on compare avec index
		btfss	STATUS,Z
		goto s1

fin_searc	btfss	flagx,v_bitd	;etat du bit derniere dif
		goto	f_search
		decf	c1_dif,f		;si a 1 une dif de moins
		btfsc	STATUS,Z
		bsf	flagx,fini		;dernier trouv = done
f_search	btfss	flagx,multidrop		;si a zero un seul ibutton
		bsf	flagx,fini		;premier et dernier trouv = done
			movfw	c1_dif			;derniere dif en cours
		movwf	c_dif			;pour memoire
		bsf	flagx,vrai
		call	calc_crc		;non donc calcul crc
		bsf	flagx,er_crc
		movfw	OWBUFFER8	
		xorwf	crc,f
		btfss	STATUS,Z		;erreur crc ?
		goto	err_ibuton		;erreur crc
		movfw	OWBUFFER1
		movwf	OWBUFFER1a		
		movfw	OWBUFFER2
		movwf	OWBUFFER2a		
		movfw	OWBUFFER3
		movwf	OWBUFFER3a		
		movfw	OWBUFFER4
		movwf	OWBUFFER4a		
		movfw	OWBUFFER5
		movwf	OWBUFFER5a		
		movfw	OWBUFFER6
		movwf	OWBUFFER6a		
		movfw	OWBUFFER7
		movwf	OWBUFFER7a		
		movfw	OWBUFFER8
		movwf	OWBUFFER8a		
		bcf	flagx,er_crc
		goto	ResetBUS	;avec retour

fn_search	bsf	flagx,er_one_wire	;dernier trouv = erreur
		goto	ResetBUS		;on sort de la routine

err_ibuton	bsf	flagx,er_one_wire
		goto	ResetBUS		;avec retour
conflit		bsf	flagx,multidrop	;signale plusieurs ibuttons sur le rseau
		incf	c1_dif,f
		movfw	c_dif		;derniere dif
		subwf	c1_dif,w	;compteur en cours
		btfsc	STATUS,Z	;dif en cours = derniere dif
		goto	wb11		;oui bit 1
		btfsc	STATUS,C	;dif en cours > derniere dif ?
		goto	wb00		;oui on met un zero
						;dif en cours < derniere dif
		btfsc	OWBUFFER1,0	;dif en cours tat du bit prcdemment
		goto 	wb1
		goto	wb0


;********************************************
;calcul du crc ds18b20

calc_crc	movlw	0
		movwf	crc			;init crc
		movfw	OWBUFFER1
		movwf	c1_dif
		movlw	8
		movwf	tmp0
		call	crc_x
		movfw	OWBUFFER2
		movwf	c1_dif
		movlw	8
		movwf	tmp0
		call	crc_x
		movfw	OWBUFFER3
		movwf	c1_dif
		movlw	8
		movwf	tmp0
		call	crc_x
		movfw	OWBUFFER4
		movwf	c1_dif
		movlw	8
		movwf	tmp0
		call	crc_x
		movfw	OWBUFFER5
		movwf	c1_dif
		movlw	8
		movwf	tmp0
		call	crc_x
		movfw	OWBUFFER6
		movwf	c1_dif
		movlw	8
		movwf	tmp0
		call	crc_x
		movfw	OWBUFFER7
		movwf	c1_dif
		movlw	8
		movwf	tmp0
		goto	crc_x		;avec retour

;*************************************************************************************************
;*************************************************************************************************
;*************************************************************************************************

;***********************************************************************************
;routine de calcul du crc d'un octet
;***********************************************************************************
crc_x		movfw	crc		;pour 1 bit
		btfss	crc,0
		goto	crc0

crc1		bcf	STATUS,C	;crc bit=1
		rrf	c1_dif,f
		btfss	STATUS,C
		goto	xor1
		goto	xor0

crc0		bcf	STATUS,C	;crc bit=0
		rrf	c1_dif,f
		btfss	STATUS,C
		goto	xor0
xor1		rrf	crc,f		;crc xor input bit=1
		bsf	crc,7
		btfss	crc,3
		goto	setbit3	
		bcf	crc,3	
x1		btfss	crc,2
		goto	setbit2	
		bcf	crc,2
		goto	fin_crc
setbit3		bsf	crc,3	
		goto	x1
setbit2		bsf	crc,2	
		goto	fin_crc

xor0		rrf	crc,F		;crc xor input bit=0
		bcf	crc,7
		btfss	crc,3
		goto	clrbit3	
		bsf	crc,3	
x0		btfss	crc,2
		goto	clrbit2	
		bsf	crc,2
		goto	fin_crc
clrbit3		bcf	crc,3
		goto	x0
clrbit2		bcf	crc,2
fin_crc		decf	tmp0,F
		btfss	STATUS,Z
		goto	crc_x
		return	

;****************************************************************************
;***********************   fin one wire   ***********************************
;****************************************************************************

